var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { setTimeout } from 'node:timers/promises';
import { lintSource } from '@secretlint/core';
import { creator } from '@secretlint/secretlint-rule-preset-recommend';
import pMap from 'p-map';
import pc from 'picocolors';
import { logger } from '../../shared/logger.js';
import { getProcessConcurrency } from '../../shared/processConcurrency.js';
export const runSecurityCheck = (rawFiles_1, ...args_1) => __awaiter(void 0, [rawFiles_1, ...args_1], void 0, function* (rawFiles, progressCallback = () => { }) {
    const secretLintConfig = createSecretLintConfig();
    const results = yield pMap(rawFiles, (rawFile, index) => __awaiter(void 0, void 0, void 0, function* () {
        progressCallback(`Running security check... (${index + 1}/${rawFiles.length}) ${pc.dim(rawFile.path)}`);
        logger.trace(`Checking security on ${rawFile.path}`);
        const processStartAt = process.hrtime.bigint();
        const secretLintResult = yield runSecretLint(rawFile.path, rawFile.content, secretLintConfig);
        const processEndAt = process.hrtime.bigint();
        logger.trace(`Checked security on ${rawFile.path}. Took: ${(Number(processEndAt - processStartAt) / 1e6).toFixed(2)}ms`);
        // Sleep for a short time to prevent blocking the event loop
        yield setTimeout(1);
        if (secretLintResult.messages.length > 0) {
            return {
                filePath: rawFile.path,
                messages: secretLintResult.messages.map((message) => message.message),
            };
        }
        return null;
    }), {
        concurrency: getProcessConcurrency(),
    });
    return results.filter((result) => result != null);
});
export const runSecretLint = (filePath, content, config) => __awaiter(void 0, void 0, void 0, function* () {
    const result = yield lintSource({
        source: {
            filePath: filePath,
            content: content,
            ext: filePath.split('.').pop() || '',
            contentType: 'text',
        },
        options: {
            config: config,
        },
    });
    if (result.messages.length > 0) {
        logger.trace(`Found ${result.messages.length} issues in ${filePath}`);
        logger.trace(result.messages.map((message) => `  - ${message.message}`).join('\n'));
    }
    return result;
});
export const createSecretLintConfig = () => ({
    rules: [
        {
            id: '@secretlint/secretlint-rule-preset-recommend',
            rule: creator,
        },
    ],
});
//# sourceMappingURL=securityCheck.js.map